#!/bin/sh
#
# Crappy shell script to create base.T negative.T & defaults.T
# for radmind based on a list o stuff that should be Negative'd
# or Defaulted.  Suitable for creating an initial group of loadsets
# for deployment.
#
# Michael Graziano <mikeg@bsd-box.net>

echo ""
echo "Base transcript build started `date`"
echo ""

if [ \! -d /var/radmind/client ]; then
	echo "Creating radmind client directory . . . "
	mkdir -p /var/radmind/client
fi

for i in `cat negative.list`; do
	if [ \! -e $i ]; then
		echo "negative.list: $i does not exist"
		exit 1;
	fi
done
for i in `cat defaults.list`; do
	if [ \! -e $i ]; then
		echo "defaults.list: $i does not exist"
		exit 1;
	fi
done

echo -n "Cleaning up existing transcripts . . . "
rm /var/radmind/client/*
touch /var/radmind/client/command.K
echo "Done"

echo -n "Generating negative transcript . . . "
for neg in `cat negative.list`; do
	fsdiff -1 -c sha1 $neg >> /var/radmind/client/base-negative-`uname -m`.T
done 
touch /var/radmind/client/base-negative-`uname -m`.T
echo "n base-negative-`uname -m`.T" >> /var/radmind/client/command.K
echo "Done"

echo -n "Generating defaults transcript . . . "
for def in `cat defaults.list`; do
	fsdiff -C -c sha1 $def >> /var/radmind/client/base-defaults-`uname -m`.T
done 
touch /var/radmind/client/base-defaults-`uname -m`.T
echo "n base-defaults-`uname -m`.T" >> /var/radmind/client/command.K
echo "Done"

echo -n "Generating base transcript . . . "
fsdiff -C -c sha1 -o /var/radmind/client/base-`uname -m`.T /
echo "Done"

echo "Updating command.K"
echo "p base-`uname -m`.T" > /var/radmind/client/command.K
echo "n base-negative-`uname -m`.T" >> /var/radmind/client/command.K
echo "n base-defaults-`uname -m`.T" >> /var/radmind/client/command.K

echo -n "Generating supplementary Information File . . . "
for sup in `cat supplementary.list`; do
	fsdiff -C -c sha1 $sup >> /var/radmind/client/base-sup-`uname -m`.T 
done
echo "Done"
touch /var/radmind/client/base-sup-`uname -m`.T
echo "p base-sup-`uname -m`.T" >> /var/radmind/client/command.K

echo ""
echo "Base transcript build completed `date`"
echo ""
